export type LineInfo = {
    listString?: string;
    text: string;
    id?: number;
    level?: number;
};
export type LineWithListInfo = {
    listString?: string;
    text: string;
    i: number;
};
export type Section = {
    text: string;
    content: string;
    listString?: string;
    i: number;
    children?: Section[];
};
export declare class OOXml {
    jObj: {};
    paragraphs: never[];
    text: string;
    fontSize: number;
    origXml: string;
    lineHeight: number;
    suppressHyphenation: boolean;
    constructor(xml: string, { ignoreMultipleFontSizes }?: {
        ignoreMultipleFontSizes?: boolean | undefined;
    });
    getContents(): string;
    setContents(t: string): void;
    getSections(lineData: LineInfo[], level?: number): Section[];
    getParagraphs(lineData: LineInfo[]): {
        text: string;
        i: number | undefined;
        listString: string | undefined;
        level: number | undefined;
    }[];
    getSectionsDeep(lineData: LineInfo[]): {
        children: Section[] | undefined;
        text: string;
        content: string;
        listString?: string;
        i: number;
    }[];
    getTOC(lineData: LineInfo[]): {
        children: Section[] | undefined;
        text: string;
        content: string;
        listString?: string;
        i: number;
    }[];
    getXml(textWithMarkup?: string): string;
    getXmlBody(textWithMarkup: string): string;
    static decompress(data: Uint8Array): Promise<string | undefined>;
}
export declare function stripCustomTags(e: string): string;
export declare function stripCommentParanthesis(arg0: string): string;
export declare function chunkMD(md: string): string[];
